<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterSchoolInfoAddMoreFields extends Migration
{
    public function up()
    {
        $this->forge->addColumn('school_info', [
            'kepsek_nama' => [
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => true,
            ],
            'kepsek_sambutan' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'kepsek_foto' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'tentang_sekolah' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'tagline' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'after' => 'school_name',
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('school_info', [
            'kepsek_nama',
            'kepsek_sambutan',
            'kepsek_foto',
            'tentang_sekolah',
        ]);
    }
}